/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
using System;
using System.Collections;
using System.Text;

namespace Inet.Viewer.Data
{

 /// <summary>
 /// Utilities class for the Viewer, helper methods, etc.
 /// </summary>
    public class ViewerUtils
    {
        private static char[] encodeDigits = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'a', 'b', 'c', 'd', 'e', 'f' };

        private static string protocolversion = null;

        /// <summary>
        /// sends the string to debug output </summary>
        /// <param name="s"> string to debug output </param>        
        public static void Debug(string s)
        {
            Console.WriteLine("DEBUG: " +s);
        }

        /// <summary>
        /// sends the string to log output </summary>
        /// <param name="s"> string to log output </param>        
        public static void Log(string s)
        {
            Console.WriteLine("LOG: " + s);
        }
        
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>        
        public static void Error(string s)
        {
            Console.WriteLine("ERROR: " + s);
        }

        /// <summary>
        /// The protocol version
        /// </summary>
        public static string ProtocolVersion
        {
            get
            {
                return protocolversion;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="e"></param>
        public static void PrintStackTrace(Exception e)
        {
            Console.WriteLine(e);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string Encode(string str)
        {
            StringBuilder buf = new StringBuilder();        
            int length = str.Length;
            for (int i = 0; i < length; i++)
            {
                char c = str[i];
                switch (c)
                {
                    case ' ':
                        buf.Append('+');
                        break;
                    case '-':
                    case '_':
                    case '.':
                    case '*':
                        buf.Append(c);
                        break;
                    default:
                        if (('0' <= c && c <= '9') || ('a' <= c && c <= 'z') || ('A' <= c && c <= 'Z'))
                        {
                            buf.Append(c);
                        }
                        else if (c < 128 && c != '&')
                        {
                            buf.Append('%');
                            buf.Append(encodeDigits[(c >> 4) & 0x0F]);
                            buf.Append(encodeDigits[c & 0x0F]);
                        }
                        else
                        {
                            // urlencodetes HTML encode, HTML encode hat die form &#xxx; -> xxx ist der decimal Wert
                            buf.Append("%26%23"); // urlencode von &#
                            buf.Append((int)c);
                            buf.Append("%3B");
                        }
                        break;
                }
            }
            return buf.ToString();
        }
    } 
}